function meta(files, fun)
%meta(files, fun)

%Copyright (C) 2008 Anton Blad, Oscar Gustafsson.
%This file is licensed under a modified version of GPL v2, see the file
%LICENSE for details.

fn = strcat(fun, '.m');
fid = fopen(fn, 'w+');

numfiles = length(files);

fprintf(fid, 'function %s(dir)\n', fun);
fprintf(fid, '%%Automatically generated by meta from source files:\n');
for f = 1:numfiles
	fprintf(fid, '%%%s\n', files{f});
end
fprintf(fid, '\n');

for f = 1:numfiles
	srcfn = files{f};
	genfn = regexprep(srcfn, '.*/', '');
	genfid = fopen(srcfn, 'r');
	
	fprintf(fid, 'fn = strcat(dir, ''/'', ''%s'');\n', genfn);
	fprintf(fid, 'fid = fopen(fn, ''w+'');\n');

	while ~feof(genfid)
		line = fgetl(genfid);
		line = sprintf('fprintf(fid, ''%s\\\\n'');\n', strrep(line, '''', ''''''));
		fprintf(fid, line);
	end
	
	fprintf(fid, 'fclose(fid);\n');
	fprintf(fid, '\n');

	fclose(genfid);
end

fclose(fid);

